package com.agilex.healthcare.veteranappointment.dataservice;


import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.veteranappointment.validator.ValidationResult;
import com.agilex.healthcare.veteranappointment.datalayer.patient.PatientPreferenceDataLayer;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;
import com.agilex.healthcare.veteranappointment.exception.InvalidPreferenceDetailsException;
import com.agilex.healthcare.veteranappointment.validator.PreferenceValidator;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/***
 * This covers calendar events created by the veteran. These are items to show
 * up on their calendar that are not "appointments"
 * 
 * @author ???
 * 
 */
@Component
public class PatientPreferenceDataService {

    @Resource
    PatientPreferenceDataLayer patientPreferenceDataLayer;

	public VARPatientPreference fetchPatientPreference(PatientIdentifier patientIdentifier) {
        VARPatientPreference patientPreference = patientPreferenceDataLayer.fetchPatientPreference(patientIdentifier);
        return patientPreference;
	}

	public VARPatientPreference updatePatientPreference(VARPatientPreference patientPreference){
		validatePatientPreference(patientPreference);
        VARPatientPreference patientPreferenceSaved = patientPreferenceDataLayer.updatePatientPreference(patientPreference);
		return patientPreferenceSaved;
	}
	
	private void validatePatientPreference(VARPatientPreference patPref) {
			PreferenceValidator validator = new PreferenceValidator();
				ValidationResult<VARPatientPreference> validationResult = validator.validate(patPref);
				if (!validationResult.isValid()) {
					throw new InvalidPreferenceDetailsException(validationResult.getErrors());
				}
	}

	public void deletePatientPreference(VARPatientPreference patientPreference){
		patientPreferenceDataLayer.deletePatientPreference(patientPreference);
	}
}
